<?= $this->include('layout/header_admin') ?>

<div class="container mt-4">
    <div class="card shadow">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Tambah Aktivitas</h5>
        </div>

        <div class="card-body">
            <form action="/auth/aktivitas/store" method="post" enctype="multipart/form-data">

                <!-- TANGGAL -->
                <div class="mb-3">
                    <label class="form-label">Tanggal</label>
                    <input type="date" name="tanggal" class="form-control" required>
                </div>

                <!-- JAM -->
                <div class="mb-3">
                    <label class="form-label">Jam</label>
                    <input type="time" name="jam" class="form-control" required>
                </div>

                <!-- NAMA AKTIVITAS -->
                <div class="mb-3">
                    <label class="form-label">Nama Aktivitas</label>
                    <input type="text" name="nama_aktivitas" class="form-control" required>
                </div>

                <!-- PILIH JENIS MEDIA -->
                <div class="mb-3">
                    <label class="form-label">Jenis Media</label>
                    <select name="media_type" class="form-select" required>
                        <option value="">-- Pilih --</option>
                        <option value="upload">Upload Foto / Video</option>
                        <option value="link">Link Media</option>
                    </select>
                </div>

                <!-- UPLOAD FILE -->
                <div class="mb-3">
                    <label class="form-label">Upload Foto / Video</label>
                    <input type="file" name="media_file" class="form-control"
                        accept="image/*,video/*">
                </div>

                <!-- LINK MEDIA -->
                <div class="mb-3">
                    <label class="form-label">Link Media</label>
                    <input type="url" name="media_link" class="form-control"
                        placeholder="https://youtube.com/...">
                </div>

                <!-- BUTTON -->
                <div class="d-flex justify-content-between">
                    <a href="/auth/aktivitas" class="btn btn-secondary">
                        ⬅ Kembali
                    </a>
                    <button class="btn btn-success">
                        💾 Simpan
                    </button>
                </div>

            </form>
        </div>
    </div>
</div>

<?= $this->include('layout/footer_admin') ?>